unit MAIN;

interface

uses
  Windows, Messages, SysUtils, Variants, Classes, Graphics, Controls, Forms,
  Dialogs, StdCtrls, ExtCtrls;

// ========================================================
//   
// List      
// Head      
// Tail      
// Element   
// Current   
// Next      
// Previous  


// ========================================================

type TTstObject = record
//    
 ptQEtop  : pointer;     //    
 CrDTime  : TDateTime;   //     
 TitStr   : string[80];  //   
 DatStr   : string[80];  //  
 ComStr   : string[80];  //  
end;

type
  ptTstObject_Type = ^TTstObject;

// ========================================================
//  
type
  TForm1 = class(TForm)
    Bevel1: TBevel;
    stxtQECount: TStaticText;
    stxtQEKey: TStaticText;
    Bevel2: TBevel;
    bttToHead: TButton;
    bttPrev: TButton;
    bttNext: TButton;
    bttToTail: TButton;
    bttAdd: TButton;
    bttDel: TButton;
    Label1: TLabel;
    Label2: TLabel;
    Label3: TLabel;
    Label4: TLabel;
    stxtQENum: TStaticText;
    Label5: TLabel;
    cboxAdd: TComboBox;
    cboxDel: TComboBox;
    Bevel3: TBevel;
    stxtHead: TStaticText;
    stxtCurrent: TStaticText;
    stxtTail: TStaticText;
    Label6: TLabel;
    Label7: TLabel;
    Label8: TLabel;
    Label9: TLabel;
    edTitStr: TEdit;
    edDatStr: TEdit;
    edComStr: TEdit;
    stxtDTime: TStaticText;
    Bevel4: TBevel;
    bttAddObj: TButton;
    bttDelObj: TButton;
    shpLink: TShape;
    bttUpDateObj: TButton;
    Label10: TLabel;
    ListBox1: TListBox;
    procedure bttAddClick(Sender: TObject);
    procedure bttNextClick(Sender: TObject);
    procedure bttPrevClick(Sender: TObject);
    procedure bttDelClick(Sender: TObject);
    procedure bttToHeadClick(Sender: TObject);
    procedure bttToTailClick(Sender: TObject);
    procedure bttAddObjClick(Sender: TObject);
    procedure bttDelObjClick(Sender: TObject);
    procedure bttUpDateObjClick(Sender: TObject);
    procedure FormCreate(Sender: TObject);
    procedure FormDestroy(Sender: TObject);
    procedure ListBox1Click(Sender: TObject);
  private
    { Private declarations }
    procedure ShowQueueStat();
    // =================    =============

    function  InsertPtObj(ptObj : pointer) : boolean;

    // ==================   Attach  ========
    procedure AddNewTstObj();
    procedure DelTstObj();
    procedure UpDateTstObj();
    procedure ShowTstObj();
    // ==================  ==========================
    procedure ShowAll();
  public
    { Public declarations }
  end;
// ========================================================
var
  Form1 : TForm1;
// ========================================================
implementation
{$R *.dfm}

uses ListDLink01;

// ========================================================
//     
// ========================================================
var
    ListDL      : TDLst;


procedure TForm1.FormCreate(Sender: TObject);
begin
   ListDL:= TDLst.Create;
end;

procedure TForm1.FormDestroy(Sender: TObject);
begin
   ListDL.Free;
end;


// ==================================
//    
// ==================================

//       
function TForm1.InsertPtObj(ptObj : pointer) : boolean;
begin
   Result := False;     //    
   ListDL.Navigate('C');
   if ListDL.ptObj = nil
   then begin
      ListDL.ptObj := ptObj;
      Result := True;
   end
   else ShowMessage(' .     ');
end;

// ========================================================
//       
// ========================================================

procedure TForm1.AddNewTstObj();
var  ptTO : ptTstObject_Type;
begin
  //        
  if ListDL.ptObj = nil
  then begin
      try
        New(ptTO); //     
        Fillchar(ptTO^, SizeOF(ptTO^),#0);  //   
        ptTO^.CrDTime := Now();             //    .
        InsertPtObj(ptTO);         //     
      except
        ShowMessage('      ');
      end;
  end
  else ShowMessage('   .  ');
end;

procedure TForm1.DelTstObj();
var  ptTO : ptTstObject_Type;
begin
  //        
  ptTO := ListDL.ptObj;
  if ptTO <> nil
  then begin
    ListDL.ptObj := nil;
    try
      Fillchar(ptTO^, SizeOF(ptTO^),#0);  // 
      Dispose(ptTO);                      //   
    except
      ShowMessage('     ');
    end;
  end;
end;

procedure TForm1.ShowTstObj();
var ptTO : ptTstObject_Type;
begin
 stxtDTime.Caption := '';
 edTitStr.Text := '';
 edDatStr.Text := '';
 edComStr.Text := '';
 ptTO := ListDL.ptObj;
 if ptTO <> nil
 then begin
    shpLink.Visible := True;
    stxtDTime.Caption := DateTimeToStr(ptTO^.CrDTime);
    edTitStr.Text := ptTO^.TitStr;
    edTitStr.Enabled := True;
    edDatStr.Text := ptTO^.DatStr;
    edDatStr.Enabled := True;
    edComStr.Text := ptTO^.ComStr;
    edComStr.Enabled := True;
 end
 else begin
    shpLink.Visible := False;
    stxtDTime.Caption := '';
    edTitStr.Text := '';
    edTitStr.Enabled := False;
    edDatStr.Text := '';
    edDatStr.Enabled := False;
    edComStr.Text := '';
    edComStr.Enabled := False;
 end;
end;

procedure TForm1.UpDateTstObj();
var ptTO : ptTstObject_Type;
begin
 ptTO := ListDL.ptObj;
 if ptTO <> nil
 then begin
    stxtDTime.Caption := DateTimeToStr(ptTO^.CrDTime);
    ptTO^.TitStr := edTitStr.Text;
    ptTO^.DatStr := edDatStr.Text;
    ptTO^.ComStr := edComStr.Text;
 end;
end;

// ========================================================
//  
// ========================================================

procedure TForm1.ShowQueueStat();
begin
  if ListDL <> nil
  then begin
    stxtQEKey.Caption := IntToStr(ListDL.Key);
    stxtQECount.Caption := IntToStr(ListDL.Count);
    stxtHead.Caption := IntToStr(ListDL.GetNumLE('H'));
    stxtCurrent.Caption := IntToStr(ListDL.GetNumLE('C'));
    stxtQENum.Caption := stxtCurrent.Caption;
    stxtTail.Caption := IntToStr(ListDL.GetNumLE('T'));
  end;
end;

procedure TForm1.ShowAll();
begin
  ShowQueueStat();
  ListDL.ViewLst(ListBox1);
  ShowTstObj();
end;

// ========================================================
procedure TForm1.bttAddClick(Sender: TObject);
begin
 ListDL.AddLE(cboxAdd.Text[1]);
 ShowAll();
end;

procedure TForm1.bttDelClick(Sender: TObject);
begin
 ListDL.DelLE(cboxDel.Text[1]);
 ShowAll();
end;
// ========================================================
procedure TForm1.bttNextClick(Sender: TObject);
begin
 ListDL.Navigate ('N');
 ShowAll();
end;

procedure TForm1.bttPrevClick(Sender: TObject);
begin
 ListDL.Navigate ('P');
 ShowAll();
end;

procedure TForm1.bttToHeadClick(Sender: TObject);
begin
 ListDL.Navigate ('H');
 ShowAll();
end;

procedure TForm1.bttToTailClick(Sender: TObject);
begin
 ListDL.Navigate ('T');
 ShowAll();
end;

procedure TForm1.ListBox1Click(Sender: TObject);
var pRqLE : TpLE;
begin
   pRqLE := pointer(ListBox1.Items.Objects[ListBox1.ItemIndex]);
   ListDL.FindAndCurr (pRqLE);
   ShowQueueStat();
   ShowTstObj();
end;

// ========================================================

procedure TForm1.bttAddObjClick(Sender: TObject);
begin
 AddNewTstObj();
 ShowAll();
end;

procedure TForm1.bttDelObjClick(Sender: TObject);
begin
 DelTstObj();
 ShowAll();
end;

procedure TForm1.bttUpDateObjClick(Sender: TObject);
begin
 UpDateTstObj();
 ShowAll();
end;


end.
